function [ DxVal, DyVal, EdgePoints ] = DQSpline_Eval( dt, Fsample, P )
%Given Delaunay and nodal values for quad spline query derivative values.
%   dt is an output of DelaundayTri.  This structure needed to use matlab's
%  locate points. fsample is a (numtri x 6 x 3) array. f(i,j,1) is
%  x-coordinate of jth node of triangle i.  Sim f(i,j,2) gives the
%  y-coordinates.  f(i,j,3) actually gives the spline's nodal value at
%  point { f(i,j,1), f(i,j,2) }.  f(i,1-3,:) are assumed to be the vertex
%  points of the triangle (crucial for the Tri_to_Std map). BUT f(i,4-6,:)
%  can be anything. P is a (numpt x 2) matrix with 1st column x-coordinates
%  and 2nd column y-coordinates of query points. EdgePoints is a column
%  vector. Each entry, if nonempty, indexes P(EdgePoints(k,1),:) is a
%  vertex lying on a triangle edge. This is to let you know the derivative
%  here is specious as the spline is only C^{0} continuous.

numpt = size(P,1);
DxVal = zeros(numpt,1);
DyVal = zeros(numpt,1);
EdgePoints = zeros(numpt,1);
%Find triangles in which points P reside
tri = pointLocation(dt,P);

Dxc = zeros(numpt,3);
Dxy = zeros(numpt,3);
%This part of code fills in spline coefficients of derivative.
for i=1:numpt
    c = Q_terp([Fsample(tri(i),:,1)' Fsample(tri(i),:,2)'],Fsample(tri(i),:,3)'); %Spline coefficients in P(i)'s triangle
    %c(1,1)+c(1,2)*x+c(1,3)*y+c(1,4)*xy+c(1,5)*x^2+c(1,6)*y^2
    Dxc(i,:) = [[c(1,2) 2*c(1,5) c(1,4)]];%Coefficients for derivatives but on {1,x,y,xy,x^2,y^2} basis
    Dyc(i,:) = [[c(1,3) c(1,4) 2*c(1,6)]]; 
end

%Calculate the derivative values at the points.
DxVal = Dxc(:,1)+Dxc(:,2).*P(1,:)+Dxc(:,3).*P(2,:);
DyVal = Dyc(:,1)+Dyc(:,2).*P(1,:)+Dyc(:,3).*P(2,:);
    
%This part of script locates those points which are on the edge of a
%triangle.

k=1;
for i=1:numpt
    if P(i,:) = 1/2*(dt.X(dt.Triangulation(tri(i,1),1),:)+dt.X(dt.Triangulation(tri(i,1),2),:)) %midpoint on 12 edge
        EdgePoints(k,1) = i;
        k = k+1;
    elseif P(i,:) = 1/2*(dt.X(dt.Triangulation(tri(i,1),2),:)+dt.X(dt.Triangulation(tri(i,1),3),:)) %midpoint on 23 edge
        EdgePoints(k,1) = i;
        k = k+1;
    elseif P(i,:) = 1/2*(dt.X(dt.Triangulation(tri(i,1),3),:)+dt.X(dt.Triangulation(tri(i,1),1),:)) %midpoint on 31 edge
        EdgePoints(k,1) = i;
        k = k+1;
    end
end

